// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     device/serial/data_stream_serialization.mojom
//

package org.chromium.mojom.device.serial;

public final class SerializedDataReceiver extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 48;
    private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(48, 0)};
    private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

    public DataSource source;
    public org.chromium.mojo.system.MessagePipeHandle client;
    public int fatalErrorValue;
    public int bytesReceived;
    public boolean paused;
    public PendingReceiveError pendingError;
    public byte[][] pendingData;

    private SerializedDataReceiver(int version) {
        super(STRUCT_SIZE, version);
        client = org.chromium.mojo.system.InvalidHandle.INSTANCE;
    }

    public SerializedDataReceiver() {
        this(0);
    }

    public static SerializedDataReceiver deserialize(org.chromium.mojo.bindings.Message message) {
        return decode(new org.chromium.mojo.bindings.Decoder(message));
    }

    @SuppressWarnings("unchecked")
    public static SerializedDataReceiver decode(org.chromium.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
        SerializedDataReceiver result = new SerializedDataReceiver(mainDataHeader.elementsOrVersion);
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.source = decoder0.readServiceInterface(8, false, DataSource.MANAGER);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.client = decoder0.readMessagePipeHandle(16, false);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.fatalErrorValue = decoder0.readInt(20);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.bytesReceived = decoder0.readInt(24);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.paused = decoder0.readBoolean(28, 0);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, true);
            result.pendingError = PendingReceiveError.decode(decoder1);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(40, false);
            {
                org.chromium.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                result.pendingData = new byte[si1.elementsOrVersion][];
                for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                    result.pendingData[i1] = decoder1.readBytes(org.chromium.mojo.bindings.DataHeader.HEADER_SIZE + org.chromium.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, org.chromium.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                }
            }
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        encoder0.encode(source, 8, false, DataSource.MANAGER);
        encoder0.encode(client, 16, false);
        encoder0.encode(fatalErrorValue, 20);
        encoder0.encode(bytesReceived, 24);
        encoder0.encode(paused, 28, 0);
        encoder0.encode(pendingError, 32, true);
        if (pendingData == null) {
            encoder0.encodeNullPointer(40, false);
        } else {
            org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(pendingData.length, 40, org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            for (int i0 = 0; i0 < pendingData.length; ++i0) {
                encoder1.encode(pendingData[i0], org.chromium.mojo.bindings.DataHeader.HEADER_SIZE + org.chromium.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, org.chromium.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            }
        }
    }

    /**
     * @see Object#equals(Object)
     */
    @Override
    public boolean equals(Object object) {
        if (object == this)
            return true;
        if (object == null)
            return false;
        if (getClass() != object.getClass())
            return false;
        SerializedDataReceiver other = (SerializedDataReceiver) object;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.source, other.source))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.client, other.client))
            return false;
        if (this.fatalErrorValue != other.fatalErrorValue)
            return false;
        if (this.bytesReceived != other.bytesReceived)
            return false;
        if (this.paused != other.paused)
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.pendingError, other.pendingError))
            return false;
        if (!java.util.Arrays.deepEquals(this.pendingData, other.pendingData))
            return false;
        return true;
    }

    /**
     * @see Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = prime + getClass().hashCode();
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(source);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(client);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(fatalErrorValue);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(bytesReceived);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(paused);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(pendingError);
        result = prime * result + java.util.Arrays.deepHashCode(pendingData);
        return result;
    }
}

